
//
// NL5 DLL functions for SystemVerilog DPI
//  09/24/2024
// (C) Sidelinesoft LLC 
//

import "DPI-C" function int NL5_OpenDLL(input string name);

import "DPI-C" function string NL5_GetInfo();
import "DPI-C" function string NL5_GetError();
import "DPI-C" function int NL5_GetLicense(input string name);

import "DPI-C" function int NL5_Open(input string name);
import "DPI-C" function int NL5_Save(input int ncir);
import "DPI-C" function int NL5_SaveAs(input int ncir, input string name);
import "DPI-C" function int NL5_Close(input int ncir);

import "DPI-C" function int NL5_GetValue(input int ncir, input string name, output real v);
import "DPI-C" function int NL5_SetValue(input int ncir, input string name, input real v);
import "DPI-C" function int NL5_GetText(input int ncir, input string name, output string text, input int length);
import "DPI-C" function int NL5_SetText(input int ncir, input string name, input string text);

import "DPI-C" function int NL5_GetParam(input int ncir, input string name);
import "DPI-C" function int NL5_GetParamValue(input int ncir, input int npar, output real v);
import "DPI-C" function int NL5_SetParamValue(input int ncir, input int npar, input real v);
import "DPI-C" function int NL5_GetParamText(input int ncir, input int npar, output string text, input int length);
import "DPI-C" function int NL5_SetParamText(input int ncir, input int npar, input string text);

import "DPI-C" function int NL5_DisableCmp(input int ncir, input string name);
import "DPI-C" function int NL5_EnableCmp(input int ncir, input string name);

import "DPI-C" function int NL5_AddVTrace(input int ncir, input string name);
import "DPI-C" function int NL5_AddITrace(input int ncir, input string name);
import "DPI-C" function int NL5_AddPTrace(input int ncir, input string name);
import "DPI-C" function int NL5_AddVarTrace(input int ncir, input string name);
import "DPI-C" function int NL5_AddFuncTrace(input int ncir, input string text);
import "DPI-C" function int NL5_AddDataTrace(input int ncir, input string text);

import "DPI-C" function int NL5_GetTracesSize(input int ncir);
import "DPI-C" function int NL5_GetTraceAt(input int ncir, input int i);
import "DPI-C" function int NL5_GetTrace(input int ncir, input string name);
import "DPI-C" function int NL5_GetTraceName(input int ncir, input int npar, output string name, input int length);
import "DPI-C" function int NL5_DeleteTrace(input int ncir, input int ntrace);
import "DPI-C" function int NL5_DeleteAllTraces(input int ncir);

import "DPI-C" function int NL5_SetTimeout(input int ncir, input int t);
import "DPI-C" function int NL5_SetStep(input int ncir, input real step);
import "DPI-C" function int NL5_GetSimulationTime(input int ncir, output real t);
import "DPI-C" function int NL5_Start(input int ncir);
import "DPI-C" function int NL5_Simulate(input int ncir, input real interval);
import "DPI-C" function int NL5_SimulateInterval(input int ncir, input real interval);
import "DPI-C" function int NL5_SimulateStep(input int ncir);
import "DPI-C" function int NL5_SaveIC(input int ncir);

import "DPI-C" function int NL5_GetInput(input int ncir, input string name);
import "DPI-C" function int NL5_SetInputValue(input int ncir, input int nin, input real v);
import "DPI-C" function int NL5_SetInputLogicalValue(input int ncir, input int nin, input int i);
import "DPI-C" function int NL5_GetOutput(input int ncir, input string name);
import "DPI-C" function int NL5_GetOutputValue(input int ncir, input int nout, output real v);
import "DPI-C" function int NL5_GetOutputLogicalValue(input int ncir, input int nout, output int v);

import "DPI-C" function int NL5_GetDataSize(input int ncir, input int ntrace);
import "DPI-C" function int NL5_GetDataAt(input int ncir, input int ntrace, input int n, output real t, output real data);
import "DPI-C" function int NL5_GetLastData(input int ncir, input int ntrace, output real t, output real data);
import "DPI-C" function int NL5_GetData(input int ncir, input int ntrace, input real t, output real data);
import "DPI-C" function int NL5_DeleteOldData(input int ncir);
import "DPI-C" function int NL5_SaveData(input int ncir, input string name);
import "DPI-C" function int NL5_AddData(input int ncir, input int ntrace, input real t, input real data);
import "DPI-C" function int NL5_DeleteData(input int ncir, input string name);

import "DPI-C" function int NL5_AddVACTrace(input int ncir, input string name);
import "DPI-C" function int NL5_AddIACTrace(input int ncir, input string name);
import "DPI-C" function int NL5_AddFuncACTrace(input int ncir, input string text);
import "DPI-C" function int NL5_AddZACTrace(input int ncir, input string text);
import "DPI-C" function int NL5_AddGammaACTrace(input int ncir);
import "DPI-C" function int NL5_AddVSWRACTrace(input int ncir);
import "DPI-C" function int NL5_AddLoopACTrace(input int ncir);

import "DPI-C" function int NL5_GetACTracesSize(input int ncir);
import "DPI-C" function int NL5_GetACTraceAt(input int ncir, input int i);
import "DPI-C" function int NL5_GetACTrace(input int ncir, input string name);
import "DPI-C" function int NL5_GetACTraceName(input int ncir, input int npar, output string name, input int length);
import "DPI-C" function int NL5_DeleteACTrace(input int ncir, input int ntrace);
import "DPI-C" function int NL5_DeleteAllACTraces(input int ncir);

import "DPI-C" function int NL5_SetACSource(input int ncir, input string name);
import "DPI-C" function int NL5_SetAC(input int ncir, input real from, input real to, input int points, input int scale);
import "DPI-C" function int NL5_CalcAC(input int ncir);

import "DPI-C" function int NL5_GetACDataSize(input int ncir, input int ntrace);
import "DPI-C" function int NL5_GetACDataAt(input int ncir, input int ntrace, input int n, output real f, output real mag, output real phase);
import "DPI-C" function int NL5_SaveACData(input int ncir, input string name);


