
//---------------------------------------------------------------------
//  SystemVerilog DPI wrapper
//  09/24/2024
// (C) Sidelinesoft LLC 
//---------------------------------------------------------------------------


#include "svdpi.h"
#include <windows.h>

static HINSTANCE h_nl5_dll = 0;

typedef char* (*t_NL5_GetInfo)(void);
static t_NL5_GetInfo _NL5_GetInfo = 0;
DPI_DLLESPEC char* NL5_GetInfo() { return _NL5_GetInfo(); }

typedef char* (*t_NL5_GetError)(void);
static t_NL5_GetError _NL5_GetError = 0;
DPI_DLLESPEC char* NL5_GetError() { return _NL5_GetError(); }

typedef int (*t_NL5_GetLicense)(char*);
static t_NL5_GetLicense _NL5_GetLicense = 0;
DPI_DLLESPEC int NL5_GetLicense(char* name) { return _NL5_GetLicense(name); }


typedef int (*t_NL5_Open)(char*);
static t_NL5_Open _NL5_Open = 0;
DPI_DLLESPEC int NL5_Open(char* name) { return _NL5_Open(name); }

typedef int (*t_NL5_Save)(int);
static t_NL5_Save _NL5_Save = 0;
DPI_DLLESPEC int NL5_Save(int ncir) { return _NL5_Save(ncir); }

typedef int (*t_NL5_SaveAs)(int, char*);
static t_NL5_SaveAs _NL5_SaveAs = 0;
DPI_DLLESPEC int NL5_SaveAs(int ncir, char* name) { return _NL5_SaveAs(ncir, name); }

typedef int (*t_NL5_Close)(int);
static t_NL5_Close _NL5_Close = 0;
DPI_DLLESPEC int NL5_Close(int ncir) { return _NL5_Close(ncir); }


typedef int (*t_NL5_GetValue)(int, char*, double*);
static t_NL5_GetValue _NL5_GetValue = 0;
DPI_DLLESPEC int NL5_GetValue(int ncir, char* name, double* val) { return _NL5_GetValue(ncir, name, val); }

typedef int (*t_NL5_SetValue)(int, char*, double);
static t_NL5_SetValue _NL5_SetValue = 0;
DPI_DLLESPEC int NL5_SetValue(int ncir, char* name, double val) { return _NL5_SetValue(ncir, name, val); }

typedef int (*t_NL5_GetText)(int, char*, char*, int);
static t_NL5_GetText _NL5_GetText = 0;
DPI_DLLESPEC int NL5_GetText(int ncir, char* name, char* text, int length) { return _NL5_GetText(ncir, name, text, length); }

typedef int (*t_NL5_SetText)(int, char*, char*);
static t_NL5_SetText _NL5_SetText = 0;
DPI_DLLESPEC int NL5_SetText(int ncir, char* name, char* text) { return _NL5_SetText(ncir, name, text); }


typedef int (*t_NL5_GetParam)(int, char*);
static t_NL5_GetParam _NL5_GetParam = 0;
DPI_DLLESPEC int NL5_GetParam(int ncir, char* name) { return _NL5_GetParam(ncir, name); }

typedef int (*t_NL5_GetParamValue)(int, int, double*);
static t_NL5_GetParamValue _NL5_GetParamValue = 0;
DPI_DLLESPEC int NL5_GetParamValue(int ncir, int npar, double* v) { return _NL5_GetParamValue(ncir, npar, v); }

typedef int (*t_NL5_SetParamValue)(int, int, double);
static t_NL5_SetParamValue _NL5_SetParamValue = 0;
DPI_DLLESPEC int NL5_SetParamValue(int ncir, int npar, double v) { return _NL5_SetParamValue(ncir, npar, v); }

typedef int (*t_NL5_GetParamText)(int, int, char*, int);
static t_NL5_GetParamText _NL5_GetParamText = 0;
DPI_DLLESPEC int NL5_GetParamText(int ncir, int npar, char* text, int length) { return _NL5_GetParamText(ncir, npar, text, length);}

typedef int (*t_NL5_SetParamText)(int, int, char*);
static t_NL5_SetParamText _NL5_SetParamText = 0;
DPI_DLLESPEC int NL5_SetParamText(int ncir, int npar, char* text) { return _NL5_SetParamText(ncir, npar, text);}


typedef int (*t_NL5_DisableCmp)(int, char*);
static t_NL5_DisableCmp _NL5_DisableCmp = 0;
DPI_DLLESPEC int NL5_DisableCmp(int ncir, char* text) { return _NL5_DisableCmp(ncir, text);}

typedef int (*t_NL5_EnableCmp)(int, char*);
static t_NL5_EnableCmp _NL5_EnableCmp = 0;
DPI_DLLESPEC int NL5_EnableCmp(int ncir, char* text) { return _NL5_EnableCmp(ncir, text);}


typedef int (*t_NL5_AddVTrace)(int, char*);
static t_NL5_AddVTrace _NL5_AddVTrace = 0;
DPI_DLLESPEC int NL5_AddVTrace(int ncir, char* name) {return _NL5_AddVTrace(ncir, name);}

typedef int (*t_NL5_AddITrace)(int, char*);
static t_NL5_AddITrace _NL5_AddITrace = 0;
DPI_DLLESPEC int NL5_AddITrace(int ncir, char* name) {return _NL5_AddITrace(ncir, name);}

typedef int (*t_NL5_AddPTrace)(int, char*);
static t_NL5_AddPTrace _NL5_AddPTrace = 0;
DPI_DLLESPEC int NL5_AddPTrace(int ncir, char* name) {return _NL5_AddPTrace(ncir, name);}

typedef int (*t_NL5_AddVarTrace)(int, char*);
static t_NL5_AddVarTrace _NL5_AddVarTrace = 0;
DPI_DLLESPEC int NL5_AddVarTrace(int ncir, char* name) { return _NL5_AddVarTrace(ncir, name);}

typedef int (*t_NL5_AddFuncTrace)(int, char*);
static t_NL5_AddFuncTrace _NL5_AddFuncTrace = 0;
DPI_DLLESPEC int NL5_AddFuncTrace(int ncir, char* text) { return _NL5_AddFuncTrace(ncir, text); }

typedef int (*t_NL5_AddDataTrace)(int, char*);
static t_NL5_AddDataTrace _NL5_AddDataTrace = 0;
DPI_DLLESPEC int NL5_AddDataTrace(int ncir, char* text) { return _NL5_AddDataTrace(ncir, text); }


typedef int (*t_NL5_GetTracesSize)(int);
static t_NL5_GetTracesSize _NL5_GetTracesSize = 0;
DPI_DLLESPEC int NL5_GetTracesSize(int ncir) { return _NL5_GetTracesSize(ncir);}

typedef int (*t_NL5_GetTraceAt)(int, int);
static t_NL5_GetTraceAt _NL5_GetTraceAt = 0;
DPI_DLLESPEC int NL5_GetTraceAt(int ncir, int i) { return _NL5_GetTraceAt(ncir, i); }

typedef int (*t_NL5_GetTrace)(int, char*);
static t_NL5_GetTrace _NL5_GetTrace = 0;
DPI_DLLESPEC int NL5_GetTrace(int ncir, char* name) { return _NL5_GetTrace(ncir, name);}

typedef int (*t_NL5_GetTraceName)(int, int, char*, int);
static t_NL5_GetTraceName _NL5_GetTraceName = 0;
DPI_DLLESPEC int NL5_GetTraceName(int ncir, int npar, char* name, int length) { return _NL5_GetTraceName(ncir, npar, name, length);}

typedef int (*t_NL5_DeleteTrace)(int, int);
static t_NL5_DeleteTrace _NL5_DeleteTrace = 0;
DPI_DLLESPEC int NL5_DeleteTrace(int ncir, int ntrace) { return _NL5_DeleteTrace(ncir, ntrace); }

typedef int (*t_NL5_DeleteAllTraces)(int);
static t_NL5_DeleteAllTraces _NL5_DeleteAllTraces = 0;
DPI_DLLESPEC int NL5_DeleteAllTraces(int ncir) { return _NL5_DeleteAllTraces(ncir); }


typedef int (*t_NL5_SetTimeout)(int, int);
static t_NL5_SetTimeout _NL5_SetTimeout = 0;
DPI_DLLESPEC int NL5_SetTimeout(int ncir, int t) { return _NL5_SetTimeout(ncir, t); }

typedef int (*t_NL5_SetStep)(int, double);
static t_NL5_SetStep _NL5_SetStep = 0;
DPI_DLLESPEC int NL5_SetStep(int ncir, double step) { return _NL5_SetStep(ncir, step); }

typedef int (*t_NL5_GetSimulationTime)(int, double*);
static t_NL5_GetSimulationTime _NL5_GetSimulationTime = 0;
DPI_DLLESPEC int NL5_GetSimulationTime(int ncir, double* t) { return _NL5_GetSimulationTime(ncir, t); }

typedef int (*t_NL5_Start)(int);
static t_NL5_Start _NL5_Start = 0;
DPI_DLLESPEC int NL5_Start(int ncir) { return _NL5_Start(ncir); }

typedef int (*t_NL5_Simulate)(int, double);
static t_NL5_Simulate _NL5_Simulate = 0;
DPI_DLLESPEC int NL5_Simulate(int ncir, double interval) { return _NL5_Simulate(ncir, interval); }

typedef int (*t_NL5_SimulateInterval)(int, double);
static t_NL5_SimulateInterval _NL5_SimulateInterval = 0;
DPI_DLLESPEC int NL5_SimulateInterval(int ncir, double interval) { return _NL5_SimulateInterval(ncir, interval); }

typedef int (*t_NL5_SimulateStep)(int);
static t_NL5_SimulateStep _NL5_SimulateStep = 0;
DPI_DLLESPEC int NL5_SimulateStep(int ncir) { return _NL5_SimulateStep(ncir); }

typedef int (*t_NL5_SaveIC)(int);
static t_NL5_SaveIC _NL5_SaveIC = 0;
DPI_DLLESPEC int NL5_SaveIC(int ncir) { return _NL5_SaveIC(ncir); }


typedef int (*t_NL5_GetInput)(int, char*);
static t_NL5_GetInput _NL5_GetInput = 0;
DPI_DLLESPEC int NL5_GetInput(int ncir, char* name) { return _NL5_GetInput(ncir, name); }

typedef int (*t_NL5_SetInputValue)(int, int, double);
static t_NL5_SetInputValue _NL5_SetInputValue = 0;
DPI_DLLESPEC int NL5_SetInputValue(int ncir, int nin, double v) { return _NL5_SetInputValue(ncir, nin, v); }

typedef int (*t_NL5_SetInputLogicalValue)(int, int, int);
static t_NL5_SetInputLogicalValue _NL5_SetInputLogicalValue = 0;
DPI_DLLESPEC int NL5_SetInputLogicalValue(int ncir, int nin, int i) { return _NL5_SetInputLogicalValue(ncir, nin, i); }

typedef int (*t_NL5_GetOutput)(int, char*);
static t_NL5_GetOutput _NL5_GetOutput = 0;
DPI_DLLESPEC int NL5_GetOutput(int ncir, char* name) { return _NL5_GetOutput(ncir, name); }

typedef int (*t_NL5_GetOutputValue)(int, int, double*);
static t_NL5_GetOutputValue _NL5_GetOutputValue = 0;
DPI_DLLESPEC int NL5_GetOutputValue(int ncir, int nout, double* v) { return _NL5_GetOutputValue(ncir, nout, v); }

typedef int (*t_NL5_GetOutputLogicalValue)(int, int, int*);
static t_NL5_GetOutputLogicalValue _NL5_GetOutputLogicalValue = 0;
DPI_DLLESPEC int NL5_GetOutputLogicalValue(int ncir, int nout, int* i) { return _NL5_GetOutputLogicalValue(ncir, nout, i); }


typedef int (*t_NL5_GetDataSize)(int, int);
static t_NL5_GetDataSize _NL5_GetDataSize = 0;
DPI_DLLESPEC int NL5_GetDataSize(int ncir, int ntrace) { return _NL5_GetDataSize(ncir, ntrace); }

typedef int (*t_NL5_GetDataAt)(int, int, int, double*, double*);
static t_NL5_GetDataAt _NL5_GetDataAt = 0;
DPI_DLLESPEC int NL5_GetDataAt(int ncir, int ntrace, int n, double* t, double* data) { return _NL5_GetDataAt(ncir, ntrace, n, t, data); }

typedef int (*t_NL5_GetLastData)(int, int, double*, double*);
static t_NL5_GetLastData _NL5_GetLastData = 0;
DPI_DLLESPEC int NL5_GetLastData(int ncir, int ntrace, double* t, double* data) { return _NL5_GetLastData(ncir, ntrace, t, data); }

typedef int (*t_NL5_GetData)(int, int, double, double*);
static t_NL5_GetData _NL5_GetData = 0;
DPI_DLLESPEC int NL5_GetData(int ncir, int ntrace, double t, double* data) { return _NL5_GetData(ncir, ntrace, t, data); }

typedef int (*t_NL5_DeleteOldData)(int);
static t_NL5_DeleteOldData _NL5_DeleteOldData = 0;
DPI_DLLESPEC int NL5_DeleteOldData(int ncir) { return _NL5_DeleteOldData(ncir); }

typedef int (*t_NL5_SaveData)(int, char*);
static t_NL5_SaveData _NL5_SaveData = 0;
DPI_DLLESPEC int NL5_SaveData(int ncir, char* name) { return _NL5_SaveData(ncir, name); }

typedef int (*t_NL5_AddData)(int, int, double, double);
static t_NL5_AddData _NL5_AddData = 0;
DPI_DLLESPEC int NL5_AddData(int ncir, int ntrace, double t, double data) { return _NL5_AddData(ncir, ntrace, t, data); }

typedef int (*t_NL5_DeleteData)(int, int);
static t_NL5_DeleteData _NL5_DeleteData = 0;
DPI_DLLESPEC int NL5_DeleteData(int ncir, int ntrace) { return _NL5_DeleteData(ncir, ntrace); }


typedef int (*t_NL5_AddVACTrace)(int, char*);
static t_NL5_AddVACTrace _NL5_AddVACTrace = 0;
DPI_DLLESPEC int NL5_AddVACTrace(int ncir, char* name) {return _NL5_AddVACTrace(ncir, name);}

typedef int (*t_NL5_AddIACTrace)(int, char*);
static t_NL5_AddIACTrace _NL5_AddIACTrace = 0;
DPI_DLLESPEC int NL5_AddIACTrace(int ncir, char* name) {return _NL5_AddIACTrace(ncir, name);}

typedef int (*t_NL5_AddFuncACTrace)(int, char*);
static t_NL5_AddFuncACTrace _NL5_AddFuncACTrace = 0;
DPI_DLLESPEC int NL5_AddFuncACTrace(int ncir, char* text) { return _NL5_AddFuncACTrace(ncir, text); }

typedef int (*t_NL5_AddZACTrace)(int, char*);
static t_NL5_AddZACTrace _NL5_AddZACTrace = 0;
DPI_DLLESPEC int NL5_AddZACTrace(int ncir, char* text) {return _NL5_AddZACTrace(ncir, char* text);}

typedef int (*t_NL5_AddGammaACTrace)(int);
static t_NL5_AddGammaACTrace _NL5_AddGammaACTrace = 0;
DPI_DLLESPEC int NL5_AddGammaACTrace(int ncir) {return _NL5_AddGammaACTrace(ncir);}

typedef int (*t_NL5_AddVSWRACTrace)(int);
static t_NL5_AddVSWRACTrace _NL5_AddVSWRACTrace = 0;
DPI_DLLESPEC int NL5_AddVSWRACTrace(int ncir) {return _NL5_AddVSWRACTrace(ncir);}

typedef int (*t_NL5_AddLoopACTrace)(int);
static t_NL5_AddLoopACTrace _NL5_AddLoopACTrace = 0;
DPI_DLLESPEC int NL5_AddLoopACTrace(int ncir) {return _NL5_AddLoopACTrace(ncir);}


typedef int (*t_NL5_GetACTracesSize)(int);
static t_NL5_GetACTracesSize _NL5_GetACTracesSize = 0;
DPI_DLLESPEC int NL5_GetACTracesSize(int ncir) { return _NL5_GetACTracesSize(ncir);}

typedef int (*t_NL5_GetACTraceAt)(int, int);
static t_NL5_GetACTraceAt _NL5_GetACTraceAt = 0;
DPI_DLLESPEC int NL5_GetACTraceAt(int ncir, int i) { return _NL5_GetACTraceAt(ncir, i); }

typedef int (*t_NL5_GetACTrace)(int, char*);
static t_NL5_GetACTrace _NL5_GetACTrace = 0;
DPI_DLLESPEC int NL5_GetACTrace(int ncir, char* name) { return _NL5_GetACTrace(ncir, name);}

typedef int (*t_NL5_GetACTraceName)(int, int, char*, int);
static t_NL5_GetACTraceName _NL5_GetACTraceName = 0;
DPI_DLLESPEC int NL5_GetACTraceName(int ncir, int npar, char* name, int length) { return _NL5_GetACTraceName(ncir, npar, name, length);}

typedef int (*t_NL5_DeleteACTrace)(int, int);
static t_NL5_DeleteACTrace _NL5_DeleteACTrace = 0;
DPI_DLLESPEC int NL5_DeleteACTrace(int ncir, int ntrace) { return _NL5_DeleteACTrace(ncir, ntrace); }

typedef int (*t_NL5_DeleteAllACTraces)(int);
static t_NL5_DeleteAllACTraces _NL5_DeleteAllACTraces = 0;
DPI_DLLESPEC int NL5_DeleteAllACTraces(int ncir) { return _NL5_DeleteAllACTraces(ncir); }


typedef int (*t_NL5_SetACSource)(int, char*);
static t_NL5_SetACSource _NL5_SetACSource = 0;
DPI_DLLESPEC int NL5_SetACSource(int ncir, char* name) { return _NL5_SetACSource(ncir, name);}

typedef int (*t_NL5_SetAC)(int, double, double, int, int);
static t_NL5_SetAC _NL5_SetAC = 0;
DPI_DLLESPEC int NL5_SetAC(int ncir, double from, double to, int points, int scale) { return _NL5_SetAC(ncir, from, to, points, scale); }

typedef int (*t_NL5_CalcAC)(int);
static t_NL5_CalcAC _NL5_CalcAC = 0;
DPI_DLLESPEC int NL5_CalcAC(int ncir) { return _NL5_CalcAC(ncir); }


typedef int (*t_NL5_GetACDataSize)(int, int);
static t_NL5_GetACDataSize _NL5_GetACDataSize = 0;
DPI_DLLESPEC int NL5_GetACDataSize(int ncir, int ntrace) { return _NL5_GetACDataSize(ncir, ntrace); }

typedef int (*t_NL5_GetACDataAt)(int, int, int, double*, double*, double*);
static t_NL5_GetACDataAt _NL5_GetACDataAt = 0;
DPI_DLLESPEC int NL5_GetACDataAt(int ncir, int ntrace, int n, double* f, double* mag, double* phase) { return _NL5_GetACDataAt(ncir, ntrace, n, f, mag, phase); }

typedef int (*t_NL5_SaveACData)(int, char*);
static t_NL5_SaveACData _NL5_SaveACData = 0;
DPI_DLLESPEC int NL5_SaveACData(int ncir, char* name) { return _NL5_SaveACData(ncir, name); }


DPI_DLLESPEC int NL5_OpenDLL(char* dll_name)
{
    if(h_nl5_dll) return -3;   // Already opened

    h_nl5_dll = LoadLibrary(dll_name);
    if(h_nl5_dll == 0) return -1;
    
    _NL5_GetInfo = (t_NL5_GetInfo)(GetProcAddress(h_nl5_dll, "NL5_GetInfo"));
    if(_NL5_GetInfo == 0) return -2;

    _NL5_GetError = (t_NL5_GetError)(GetProcAddress(h_nl5_dll, "NL5_GetError"));
    if(_NL5_GetError == 0) return -2;

    _NL5_GetLicense = (t_NL5_GetLicense)(GetProcAddress(h_nl5_dll, "NL5_GetLicense"));
    if(_NL5_GetLicense == 0) return -2;

    
    _NL5_Open = (t_NL5_Open)(GetProcAddress(h_nl5_dll, "NL5_Open"));
    if(_NL5_Open == 0) return -2;

    _NL5_Save = (t_NL5_Save)(GetProcAddress(h_nl5_dll, "NL5_Save"));
    if(_NL5_Save == 0) return -2;

    _NL5_SaveAs = (t_NL5_SaveAs)(GetProcAddress(h_nl5_dll, "NL5_SaveAs"));
    if(_NL5_SaveAs == 0) return -2;

    _NL5_Close = (t_NL5_Close)(GetProcAddress(h_nl5_dll, "NL5_Close"));
    if(_NL5_Close == 0) return -2;


    _NL5_GetValue = (t_NL5_GetValue)(GetProcAddress(h_nl5_dll, "NL5_GetValue"));
    if(_NL5_GetValue == 0) return -2;

    _NL5_SetValue = (t_NL5_SetValue)(GetProcAddress(h_nl5_dll, "NL5_SetValue"));
    if(_NL5_SetValue == 0) return -2;

    _NL5_GetText = (t_NL5_GetText)(GetProcAddress(h_nl5_dll, "NL5_GetText"));
    if(_NL5_GetText == 0) return -2;

    _NL5_SetText = (t_NL5_SetText)(GetProcAddress(h_nl5_dll, "NL5_SetText"));
    if(_NL5_SetText == 0) return -2;


    _NL5_GetParam = (t_NL5_GetParam)(GetProcAddress(h_nl5_dll, "NL5_GetParam"));
    if(_NL5_GetParam == 0) return -2;

    _NL5_GetParamValue = (t_NL5_GetParamValue)(GetProcAddress(h_nl5_dll, "NL5_GetParamValue"));
    if(_NL5_GetParamValue == 0) return -2;

    _NL5_SetParamValue = (t_NL5_SetParamValue)(GetProcAddress(h_nl5_dll, "NL5_SetParamValue"));
    if(_NL5_SetParamValue == 0) return -2;

    _NL5_GetParamText = (t_NL5_GetParamText)(GetProcAddress(h_nl5_dll, "NL5_GetParamText"));
    if(_NL5_GetParamText == 0) return -2;

    _NL5_SetParamText = (t_NL5_SetParamText)(GetProcAddress(h_nl5_dll, "NL5_SetParamText"));
    if(_NL5_SetParamText == 0) return -2;


    _NL5_DisableCmp = (t_NL5_DisableCmp)(GetProcAddress(h_nl5_dll, "NL5_DisableCmp"));
    if(_NL5_DisableCmp == 0) return -2;

    _NL5_EnableCmp = (t_NL5_EnableCmp)(GetProcAddress(h_nl5_dll, "NL5_EnableCmp"));
    if(_NL5_EnableCmp == 0) return -2;


	_NL5_AddVTrace = (t_NL5_AddVTrace)(GetProcAddress(h_nl5_dll, "NL5_AddVTrace"));
    if(_NL5_AddVTrace == 0) return -2;

    _NL5_AddITrace = (t_NL5_AddITrace)(GetProcAddress(h_nl5_dll, "NL5_AddITrace"));
    if(_NL5_AddITrace == 0) return -2;

	_NL5_AddPTrace = (t_NL5_AddPTrace)(GetProcAddress(h_nl5_dll, "NL5_AddPTrace"));
    if(_NL5_AddPTrace == 0) return -2;

	_NL5_AddVarTrace = (t_NL5_AddVarTrace)(GetProcAddress(h_nl5_dll, "NL5_AddVarTrace"));
    if(_NL5_AddVarTrace == 0) return -2;

	_NL5_AddFuncTrace = (t_NL5_AddFuncTrace)(GetProcAddress(h_nl5_dll, "NL5_AddFuncTrace"));
	if(_NL5_AddFuncTrace == 0) return -2;

	_NL5_AddDataTrace = (t_NL5_AddDataTrace)(GetProcAddress(h_nl5_dll, "NL5_AddDataTrace"));
	if(_NL5_AddDataTrace == 0) return -2;


    _NL5_GetTracesSize = (t_NL5_GetTracesSize)(GetProcAddress(h_nl5_dll, "NL5_GetTracesSize"));
	if(_NL5_GetTracesSize == 0) return -2;

    _NL5_GetTraceAt = (t_NL5_GetTraceAt)(GetProcAddress(h_nl5_dll, "NL5_GetTraceAt"));
	if(_NL5_GetTraceAt == 0) return -2;

    _NL5_GetTrace = (t_NL5_GetTrace)(GetProcAddress(h_nl5_dll, "NL5_GetTrace"));
	if(_NL5_GetTrace == 0) return -2;

    _NL5_GetTraceName = (t_NL5_GetTraceName)(GetProcAddress(h_nl5_dll, "NL5_GetTraceName"));
    if(_NL5_GetTraceName == 0) return -2;

    _NL5_DeleteTrace = (t_NL5_DeleteTrace)(GetProcAddress(h_nl5_dll, "NL5_DeleteTrace"));
	if(_NL5_DeleteTrace == 0) return -2;

    _NL5_DeleteAllTraces = (t_NL5_DeleteAllTraces)(GetProcAddress(h_nl5_dll, "NL5_DeleteAllTraces"));
	if(_NL5_DeleteAllTraces == 0) return -2;


	_NL5_SetTimeout = (t_NL5_SetTimeout)(GetProcAddress(h_nl5_dll, "NL5_SetTimeout"));
    if(_NL5_SetTimeout == 0) return -2;
	
	_NL5_SetStep = (t_NL5_SetStep)(GetProcAddress(h_nl5_dll, "NL5_SetStep"));
    if(_NL5_SetStep == 0) return -2;

    _NL5_GetSimulationTime = (t_NL5_GetSimulationTime)(GetProcAddress(h_nl5_dll, "NL5_GetSimulationTime"));
    if(_NL5_GetSimulationTime == 0) return -2;

    _NL5_Start = (t_NL5_Start)(GetProcAddress(h_nl5_dll, "NL5_Start"));
    if(_NL5_Start == 0) return -2;

    _NL5_Simulate = (t_NL5_Simulate)(GetProcAddress(h_nl5_dll, "NL5_Simulate"));
    if(_NL5_Simulate == 0) return -2;

    _NL5_SimulateInterval = (t_NL5_SimulateInterval)(GetProcAddress(h_nl5_dll, "NL5_SimulateInterval"));
    if(_NL5_SimulateInterval == 0) return -2;

    _NL5_SimulateStep = (t_NL5_SimulateStep)(GetProcAddress(h_nl5_dll, "NL5_SimulateStep"));
    if(_NL5_SimulateStep == 0) return -2;

    _NL5_SaveIC = (t_NL5_SaveIC)(GetProcAddress(h_nl5_dll, "NL5_SaveIC"));
    if(_NL5_SaveIC == 0) return -2;


    _NL5_GetInput = (t_NL5_GetInput)(GetProcAddress(h_nl5_dll, "NL5_GetInput"));
    if(_NL5_GetInput == 0) return -2;

    _NL5_SetInputValue = (t_NL5_SetInputValue)(GetProcAddress(h_nl5_dll, "NL5_SetInputValue"));
    if(_NL5_SetInputValue == 0) return -2;

    _NL5_SetInputLogicalValue = (t_NL5_SetInputLogicalValue)(GetProcAddress(h_nl5_dll, "NL5_SetInputLogicalValue"));
    if(_NL5_SetInputLogicalValue == 0) return -2;

    _NL5_GetOutput = (t_NL5_GetOutput)(GetProcAddress(h_nl5_dll, "NL5_GetOutput"));
    if(_NL5_GetOutput == 0) return -2;

    _NL5_GetOutputValue = (t_NL5_GetOutputValue)(GetProcAddress(h_nl5_dll, "NL5_GetOutputValue"));
    if(_NL5_GetOutputValue == 0) return -2;

    _NL5_GetOutputLogicalValue = (t_NL5_GetOutputLogicalValue)(GetProcAddress(h_nl5_dll, "NL5_GetOutputLogicalValue"));
    if(_NL5_GetOutputLogicalValue == 0) return -2;


	_NL5_GetDataSize = (t_NL5_GetDataSize)(GetProcAddress(h_nl5_dll, "NL5_GetDataSize"));
	if(_NL5_GetDataSize == 0) return -2;

	_NL5_GetDataAt = (t_NL5_GetDataAt)(GetProcAddress(h_nl5_dll, "NL5_GetDataAt"));
	if(_NL5_GetDataAt == 0) return -2;

	_NL5_GetLastData = (t_NL5_GetLastData)(GetProcAddress(h_nl5_dll, "NL5_GetLastData"));
	if(_NL5_GetLastData == 0) return -2;

	_NL5_GetData = (t_NL5_GetData)(GetProcAddress(h_nl5_dll, "NL5_GetData"));
	if(_NL5_GetData == 0) return -2;

    _NL5_DeleteOldData = (t_NL5_DeleteOldData)(GetProcAddress(h_nl5_dll, "NL5_DeleteOldData"));
    if(_NL5_DeleteOldData == 0) return -2;

    _NL5_SaveData = (t_NL5_SaveData)(GetProcAddress(h_nl5_dll, "NL5_SaveData"));
    if(_NL5_SaveData == 0) return -2;
	
	_NL5_AddData = (t_NL5_AddData)(GetProcAddress(h_nl5_dll, "NL5_AddData"));
	if(_NL5_AddData == 0) return -2;

	_NL5_DeleteData = (t_NL5_DeleteData)(GetProcAddress(h_nl5_dll, "NL5_DeleteData"));
	if(_NL5_DeleteData == 0) return -2;


	_NL5_AddVACTrace = (t_NL5_AddVACTrace)(GetProcAddress(h_nl5_dll, "NL5_AddVACTrace"));
    if(_NL5_AddVACTrace == 0) return -2;

    _NL5_AddIACTrace = (t_NL5_AddIACTrace)(GetProcAddress(h_nl5_dll, "NL5_AddIACTrace"));
    if(_NL5_AddIACTrace == 0) return -2;

	_NL5_AddFuncACTrace = (t_NL5_AddFuncACTrace)(GetProcAddress(h_nl5_dll, "NL5_AddFuncACTrace"));
	if(_NL5_AddFuncACTrace == 0) return -2;

    _NL5_AddZACTrace = (t_NL5_AddZACTrace)(GetProcAddress(h_nl5_dll, "NL5_AddZACTrace"));
    if(_NL5_AddZACTrace == 0) return -2;

    _NL5_AddGammaACTrace = (t_NL5_AddGammaACTrace)(GetProcAddress(h_nl5_dll, "NL5_AddGammaACTrace"));
    if(_NL5_AddGammaACTrace == 0) return -2;

    _NL5_AddVSWRACTrace = (t_NL5_AddVSWRACTrace)(GetProcAddress(h_nl5_dll, "NL5_AddVSWRACTrace"));
    if(_NL5_AddVSWRACTrace == 0) return -2;

    _NL5_AddLoopACTrace = (t_NL5_AddLoopACTrace)(GetProcAddress(h_nl5_dll, "NL5_AddLoopACTrace"));
    if(_NL5_AddLoopACTrace == 0) return -2;

    _NL5_GetACTracesSize = (t_NL5_GetACTracesSize)(GetProcAddress(h_nl5_dll, "NL5_GetACTracesSize"));
	if(_NL5_GetACTracesSize == 0) return -2;

    _NL5_GetACTraceAt = (t_NL5_GetACTraceAt)(GetProcAddress(h_nl5_dll, "NL5_GetACTraceAt"));
	if(_NL5_GetACTraceAt == 0) return -2;

    _NL5_GetACTrace = (t_NL5_GetACTrace)(GetProcAddress(h_nl5_dll, "NL5_GetACTrace"));
	if(_NL5_GetACTrace == 0) return -2;
	
    _NL5_GetACTraceName = (t_NL5_GetACTraceName)(GetProcAddress(h_nl5_dll, "NL5_GetACTraceName"));
    if(_NL5_GetACTraceName == 0) return -2;

    _NL5_DeleteACTrace = (t_NL5_DeleteACTrace)(GetProcAddress(h_nl5_dll, "NL5_DeleteACTrace"));
	if(_NL5_DeleteACTrace == 0) return -2;

    _NL5_DeleteAllACTraces = (t_NL5_DeleteAllACTraces)(GetProcAddress(h_nl5_dll, "NL5_DeleteAllACTraces"));
	if(_NL5_DeleteAllACTraces == 0) return -2;


	_NL5_SetACSource = (t_NL5_SetACSource)(GetProcAddress(h_nl5_dll, "NL5_SetACSource"));
	if(_NL5_SetACSource == 0) return -2;

	_NL5_SetAC = (t_NL5_SetAC)(GetProcAddress(h_nl5_dll, "NL5_SetAC"));
	if(_NL5_SetAC == 0) return -2;

	_NL5_CalcAC = (t_NL5_CalcAC)(GetProcAddress(h_nl5_dll, "NL5_CalcAC"));
	if(_NL5_CalcAC == 0) return -2;

	
	_NL5_GetACDataSize = (t_NL5_GetACDataSize)(GetProcAddress(h_nl5_dll, "NL5_GetACDataSize"));
	if(_NL5_GetACDataSize == 0) return -2;
	
	_NL5_GetACDataAt = (t_NL5_GetACDataAt)(GetProcAddress(h_nl5_dll, "NL5_GetACDataAt"));
	if(_NL5_GetACDataAt == 0) return -2;
	
    _NL5_SaveACData = (t_NL5_SaveACData)(GetProcAddress(h_nl5_dll, "NL5_SaveACData"));
    if(_NL5_SaveACData == 0) return -2;
	
	return 0;
}


