# -*- coding: utf-8 -*-

# import required modules
import nl5py as nl5
import ctypes as ct
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# open schematic
ncir = nl5.NL5_Open(b'dll_example.nl5')

# create trace handle
ntrace = nl5.NL5_GetACTrace(ncir, b'V(out)')
ndata = nl5.NL5_GetACDataSize(ncir, ntrace)

# create pointer to data
freq = ct.c_double()
mag = ct.c_double()
phase = ct.c_double()

# initialize
R = np.logspace(-2, 1, 50)
Z = np.zeros((50, 100))

for k in range(50):
    # set R1 value
    nl5.NL5_SetValue(ncir, b'R1.R', R[k])
    
    # simulate AC
    nl5.NL5_CalcAC(ncir)

    # read data
    for t in range(100):
        nl5.NL5_GetACDataAt(ncir, ntrace, t, freq, mag, phase)
        Z[k, t] = 20.0*np.log10(mag.value)
    
# close document
nl5.NL5_Close(ncir)
print(nl5.NL5_GetError())

# plot a 3D Surface
X = np.linspace(1, 100, 100)
Y = np.linspace(1, 50, 50)
Y, X = np.meshgrid(X, Y)

# formatting the figure
fig = plt.figure(figsize=(5, 5))
ax = fig.add_subplot(111, projection='3d')
ax.set_zlim(-60, 20)
mycmap = plt.get_cmap('jet')
plt.gca().invert_xaxis()

# plotting the surface
surf = ax.plot_surface(X, Y, Z, cmap=mycmap)

# adding the colorbar
cb = plt.colorbar(surf)

ax.view_init(45, 15)

plt.show()

