clear;
clc;
close all;
R=logspace(-2,1,50);

% load library
loadlibrary('nl5_dll.dll', 'nl5_dll.h');

% open schematic
is = calllib('nl5_dll', 'NL5_Open', 'dll_example.nl5');
calllib('nl5_dll', 'NL5_GetError');

% get trace handle
it = calllib('nl5_dll', 'NL5_GetACTrace', is, 'V(out)');

% create pointers to data
freq = libpointer('doublePtr', 0.0);
mag = libpointer('doublePtr', 0.0);
phase = libpointer('doublePtr', 0.0);

for k=1:50

    % set R1 value
	calllib('nl5_dll', 'NL5_SetValue', is, 'R1', R(k));
	
    % simulate for 10 s
    calllib('nl5_dll', 'NL5_CalcAC', is);

    % read data
	for i=1:100
		calllib('nl5_dll', 'NL5_GetACDataAt', is, it, i, freq, mag, phase);	
		Z(k,i)=20.0*log10(mag.value);
	end

end

% close document
calllib('nl5_dll', 'NL5_Close', is);
calllib('nl5_dll', 'NL5_GetError');

% unload library
unloadlibrary 'nl5_dll';

[X,Y] = meshgrid(1:100,1:50);
surf(X,Y,Z);
shading flat;
colormap jet;
colorbar;
ylim([0 50]);
view(45,15)

